/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Weather
**
** DESCRIPTION:	Weather
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef WEATHER_H
#define WEATHER_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int Weather_c_iChanceOfInitialWeatherNotSunny = 20;
const int Weather_c_iMinTimeUntilNextWeatherWhenSunny = 15 * 60;
const int Weather_c_iMaxTimeUntilNextWeatherWhenSunny = 30 * 60;
const int Weather_c_iMinTimeUntilNextWeatherWhenNotSunny = 3 * 60;
const int Weather_c_iMaxTimeUntilNextWeatherWhenNotSunny = 6 * 60;
const int Weather_c_iTimeToDry = 4 * 60;
const int Weather_c_iTimeToFullWetness = 2 * 60;

/******************************************************************************\
** CLASS ENUMERATIONS
\******************************************************************************/
enum EWeather
{
	eWeather_None = -1,

	eWeather_Sunny = 0,
	eWeather_Cloudy,
	eWeather_Raining,
	eWeather_Stormy,
	eWeather_Foggy,

	eWeather_NumberOf
};

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CWeather
{
private:

	//class data
	EWeather		m_eCurrentWeather;
	EWeather		m_eNextWeather;
	unsigned int	m_uiNextWeatherTime;
	unsigned int	m_uiChangeTime;
	int				m_iWetnessAtChange;
	int				m_iWetness;
	float			m_fTargetDullness;
	float			m_fDullness;
	float			m_fDullnessAtChange;

	float			m_fTargetIntensity;
	float			m_fCurrentIntensity;
	float			m_fIntensityAtChange;
	unsigned int	m_uiIntensityChangeTime;
	int				m_iSecondsToReachTarget;

	//class methods
	//setup
	public:		CWeather();
	public:		~CWeather();
	public:		void Reset();
	
	//process
	public:		void Update();
	public:		void Draw();

	//access
	public:		void SetCurrent(EWeather eWeather, const int iSecondsElapsed = 0);
	public:		const EWeather Current() const { return m_eCurrentWeather; }
	public:		void SetNext(EWeather eWeather);
	public:		const EWeather Next() const { return m_eNextWeather; }
	public:		const char *CurrentTypeString() const;
	public:		const int Wetness() const { return m_iWetness; }
	public:		void SetWetness(const int iWetness);
	private:	void SetTargetIntensity(const float fTargetIntensity, const int iSecondsToReachTarget = 1);
	public:		const float CurrentIntensity() const { return m_fCurrentIntensity; }
	public:		const EWeather Random(const EWeather eExceptFor = eWeather_None) const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CWeather		Weather;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/